-- On retourne dans la base avec les donnes en clair via la procdure
USE DB_CLEAR
GO

-- On cre la cl principale de la base
CREATE MASTER KEY ENCRYPTION BY PASSWORD = 'Austin Powers !';
GO

-- On cre le certificat afin de signer les donnes
CREATE CERTIFICATE CRT_SIGN_CROSS
WITH SUBJECT = N'Signature des modules interbase', EXPIRY_DATE = '20201231';
GO

-- On signe la procdure
ADD SIGNATURE TO dbo.P_PATIENT_PTT BY CERTIFICATE CRT_SIGN_CROSS;
GO

-- On supprime par scurit la cl du certificat
ALTER CERTIFICATE CRT_SIGN_CROSS REMOVE PRIVATE KEY;
GO

-- On sauvegarde le certificat
BACKUP CERTIFICATE CRT_SIGN_CROSS
TO FILE = 'C:\DATACRYPT\CERTIF\CRT_SIGN_CROSS.cert';
GO

-- On retourne dans la base contenant les donnes cryptes
USE DB_CRYPT
GO

-- On cre un certificat bas sur le certificat de lautre base
CREATE CERTIFICATE CRT_SIGN_CROSS
FROM FILE = 'C:\DATACRYPT\CERTIF\CRT_SIGN_CROSS.cert';
GO

-- On cre un utilisateur particulier engendr par le certificat
CREATE USER USR_SIGN_CERTIF FROM CERTIFICATE CRT_SIGN_CROSS;
GO

-- On octroie  cet utilisateur le privilge permettant de lire la table des patients
GRANT SELECT ON OBJECT::dbo.T_PATIENT_PTT TO USR_SIGN_CERTIF;
GO

-- On se place dans le contexte de la base master
USE master;
GO

-- On indique que les deux bases sont dignes de confiance
ALTER DATABASE DB_CLEAR SET TRUSTWORTHY ON;
ALTER DATABASE DB_CRYPT SET TRUSTWORTHY ON;